/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class ExtremityStateLine2
extends Extremity {
    private UPolygon polygon = new UPolygon();
    private final Point2D dest;
    private final double radius = 5.0;
    private final double angle;

    public ExtremityStateLine2(double angle, Point2D center) {
        this.angle = this.manageround(angle);
        this.polygon.addPoint(0.0, 0.0);
        this.dest = new Point2D.Double(center.getX(), center.getY());
        int xAile = 9;
        int yOuverture = 4;
        this.polygon.addPoint(-9.0, -4.0);
        int xContact = 5;
        this.polygon.addPoint(-5.0, 0.0);
        this.polygon.addPoint(-9.0, 4.0);
        this.polygon.addPoint(0.0, 0.0);
        this.polygon.rotate(this.angle);
        this.polygon = this.polygon.translate(center.getX(), center.getY());
    }

    @Override
    public void drawU(UGraphic ug) {
        ug.apply(new UChangeBackColor(ug.getParam().getColor())).apply(new UTranslate(-5.0 * Math.cos(this.angle), -5.0 * Math.sin(this.angle))).draw(this.polygon);
        ug.apply(new UStroke(1.5)).apply(new UChangeBackColor(HtmlColorUtils.WHITE)).apply(new UTranslate(this.dest.getX() - 5.0, this.dest.getY() - 5.0)).draw(new UEllipse(10.0, 10.0));
    }
}

